<?php
/*--------------------------------------------------------------------
 AttributeGroupReader.php 2020-2-18
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/
declare(strict_types=1);
namespace Gambio\Shop\Attributes\ProductModifiers\Database\Readers;

use CI_DB_query_builder;
use Gambio\Shop\ProductModifiers\Database\Core\DTO\Groups\GroupDTOBuilderInterface;
use Gambio\Shop\ProductModifiers\Database\Core\DTO\Groups\GroupDTOCollection;
use Gambio\Shop\ProductModifiers\Database\Core\DTO\Groups\GroupDTOCollectionInterface;
use Gambio\Shop\ProductModifiers\Database\Core\Readers\Interfaces\GroupReaderCompositeInterface;
use Gambio\Shop\Attributes\ProductModifiers\Database\ValueObjects\AttributeGroupIdentifier;
use Gambio\Shop\Product\ValueObjects\ProductId;
use IdType;

/**
 * Class AttributeGroupReader
 * @package Gambio\Shop\Attributes\ProductModifiers\Database\Readers
 */
class AttributeGroupReader implements GroupReaderCompositeInterface
{
    /**
     * @var GroupDTOBuilderInterface
     */
    private $builder;
    
    /**
     * @var CI_DB_query_builder
     */
    private $queryBuilder;
    
    
    /**
     * AttributeGroupReader constructor.
     *
     * @param CI_DB_query_builder      $queryBuilder
     * @param GroupDTOBuilderInterface $builder
     */
    public function __construct(CI_DB_query_builder $queryBuilder, GroupDTOBuilderInterface $builder)
    {
        $this->queryBuilder = $queryBuilder;
        $this->builder      = $builder;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getGroupsByProduct(
        ProductId $id,
        IdType $languageId
    ): GroupDTOCollectionInterface {
        $result = new GroupDTOCollection();
        
        // search the database, loop the result and call the builder to return a list
        $sql = "SELECT po.products_options_name, po.products_options_id, po.products_option_display_type
                    FROM products_attributes pa
                        INNER JOIN products_options po ON pa.options_id = po.products_options_id
                    WHERE pa.products_id = {$id->value()} AND po.language_id = {$languageId->asInt()}
                    GROUP BY po.products_options_name, po.products_options_id, po.products_option_display_type;";
        
        $data = $this->queryBuilder->query($sql)->result_array();
        
        foreach ($data as $item) {
            $result->addGroup($this->builder->withId(new AttributeGroupIdentifier((int)$item['products_options_id']))
                                            ->withName($item['products_options_name'])
                                            ->withType($item['products_option_display_type'])
                                            ->withSource('attribute')
                                            ->build());
        }
        
        return $result;
    }
}